package com.example.bytesbee.alphabets.activities;

import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.example.bytesbee.alphabets.activities.constants.IAlphaListener;
import com.example.bytesbee.alphabets.activities.constants.StaticNames;
import com.example.bytesbee.alphabets.activities.views.GestureDetectListner;
import com.example.bytesbee.alphabets.activities.R;
import com.example.bytesbee.alphabets.activities.utils.Utils;
import com.polyak.iconswitch.IconSwitch;

/**
 * @author Prashant
 * @company BytesBee
 * @link http://bytesbee.com/
 */
public class NumberActivity extends BaseActivity implements GestureDetectListner.SimpleGestureListener, View.OnClickListener {

    private ImageView imgAlphabet;
    private TextView txtThemeType;
    private GestureDetectListner detector;
    private int position = 0;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        setContentView(R.layout.alphabet_activity);
        super.onCreate(savedInstanceState);

        imgAlphabet = findViewById(R.id.imgAlphabet);
        txtThemeType = findViewById(R.id.txtThemeType);

        final IconSwitch iconSwitch = findViewById(R.id.iconSwitch);
        iconSwitch.setVisibility(View.GONE);

        detector = new GestureDetectListner(this, this);

        loadAudio(position);

        loadImageSource(position);

        imgAlphabet.setOnClickListener(this);
        txtThemeType.setOnClickListener(this);
        btnPrevious.setOnClickListener(this);
        btnNext.setOnClickListener(this);
        play.setOnClickListener(this);

        Utils.loadBannerAd(mActivity);
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.imgAlphabet) {
            loadAudio(position);
        } else if (id == R.id.txtThemeType) {
            Utils.selectTheme(mActivity, session.getNumberValue(), new IAlphaListener() {
                @Override
                public void clickListener(String strSelectedTheme) {
                    session.setNumberValue(strSelectedTheme);
                    loadImageSource(position);
                    loadAudio(position);
                }
            });
        } else if (id == R.id.btnPrev) {
            showPrevious();
        } else if (id == R.id.btnNext) {
            showNext();
        } else if (id == R.id.play) {
            playAudio(position);
        }
    }

    private void loadAudio(final int position) {
        bounceView(imgAlphabet);
        playAudio(Utils.getRawAudioDefault(mActivity, StaticNames.STR_NUMBERS[position]));
    }

    private void loadImageSource(final int position) {
        String themeType = session.getNumberType();
        txtThemeType.setText(String.format(getString(R.string.themeSelected), session.getNumberValue().toUpperCase()));
        imgAlphabet.setImageResource(Utils.getDrawableImage(mActivity, themeType, StaticNames.STR_NUMBERS[position]));
    }

    private void updateActivity(final int position) {
        loadImageSource(position);
        loadAudio(position);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent me) {
        this.detector.onTouchEvent(me);
        return super.dispatchTouchEvent(me);
    }

    @Override
    public void onSwipe(int direction) {
        switch (direction) {

            case GestureDetectListner.SWIPE_RIGHT:

                showPrevious();

                break;

            case GestureDetectListner.SWIPE_LEFT:

                showNext();

                break;
        }

    }

    private void showPrevious() {
        if (position > 0) {
            updateActivity(position - 1);
            position = position - 1;
        } else {
            updateActivity((StaticNames.STR_NUMBERS.length - 1));
            position = StaticNames.STR_NUMBERS.length - 1;
        }
    }

    private void showNext() {
        if (position < (StaticNames.STR_NUMBERS.length - 1)) {
            updateActivity(position + 1);
            position = position + 1;
        } else {
            updateActivity(0);
            position = 0;
        }
    }

    protected void onPause() {
        super.onPause();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }
}